///////////////////////////////////////////////////////////
// Tracker scheme resource file
//
// sections:
//		Colors			- all the colors used by the scheme
//		BaseSettings		- contains settings for app to use to draw controls
//		Fonts			- list of all the fonts used by app
//		Borders			- description of all the borders
//
///////////////////////////////////////////////////////////
Scheme
{
	//////////////////////// COLORS ///////////////////////////
	// color details
	// this is a list of all the colors used by the scheme
	Colors
	{
		// base colors
		"White"				"255 255 255 255"
		"TransparentLightGray"		"0 0 0 128"
		"Black"				"0 0 0 255"
		"Blank"				"1 1 1 0"
		"TestColor"			"0 0 0 255"
		"LightGray"			"75 75 75 255"
		"DarkGray"			"36 36 36 255"

		// scheme-specific colors	
		"DialogText1"			"56 56 56 255"		// listpanel sort headings, menu top text, important dialog text
		"DialogText2"			"113 113 113 255"		// detailed dialog text
		"Highlight1"			"25 25 25 255"		// text Highlight foreground
		"Highlight2"			"0 0 0 255"		// shaded control Hightlight
		"Highlight3"			"0 0 0 255"		// unshaded control Hightlight
			
		"ListBG"				"215 215 215 255"		// listpanel interior (games, servers)

		"PriBG"				"206 206 206 255"		// primary background colour - behind property sheets, server info, etc
		"SecBG"				"230 230 230 255"		// property sheet interior, active tab
		
		"PriFGDisabled"			"170 170 170 255"		// disabled primary controls
		"SecFGDisabled"			"190 190 190 255"		// disabled secondary controls
		
		"TabBGInactive"			"206 206 206 255"		// unselected tab background
		"SecBGGradient"			"92 89 87 255"		// property sheet background gradient
		
		"PriButtonBG"			"230 230 230 255"		// primary button background colour (OK, Cancel)
		"SecButtonBG"			"200 200 200 255"		// secondary button background colour (property sheet interior)
		
		"MenuBG"				"206 206 206 255"		// menu background color
		"MenuFG"				"56 56 56 255"		// menu text color
		"MenuFGDisabled"			"175 175 175 255"		// text on disabled menu items

		"Highlight1BG"			"133 207 45 255"		// background colour of any selected text or menu item
		"Highlight1FG"			"255 255 255 255"		// foreground colour of any selected text or menu item
		
		"ScrollFG"				"230 230 230 255"		// inside of scrollbar buttons
		"ScrollBG"				"206 206 206 255"		// background of scrollbar buttons

		// background colors

		// titlebar colors
		"TitleFG"				"62 56 51 255"
		"TitleFGDim"			"62 56 51 255"
		"TitleBG"				"230 230 230 255"
		"TitleBGDim"			"230 230 230 255"
		
				
		// gameslist
		"GLInstalled"			"56 56 56 255"
		"GLNotInstalled"			"175 175 175 255"
		"GLUpdating"			"202 123 0 255"
		
		// slider tick colors
		"SliderTickColor"			"127 140 127 255"
		"SliderTrackColor"			"31 31 31 255"

		// border colors - unused for Steam 3 skins
		"BorderBright"			"128 128 128 255"		// the lit side of a control
		"BorderDark"			"40 46 34 255"		// the dark/unlit side of a control
		"BorderSelection"			"0 0 0 255"		// the additional border color for displaying the default/selected button
	}
	

	///////////////////// BASE SETTINGS ////////////////////////
	//
	// default settings for all panels
	// controls use these to determine their settings
	BaseSettings
	{
		// vgui_controls color specifications
		Border.Bright					"BorderBright"		// the lit side of a control
		Border.Dark					"BorderDark"		// the dark/unlit side of a control
		Border.Selection					"BorderSelection"		// the additional border color for displaying the default/selected button

		CheckButton.BgColor				"DarkGreenBG"
		CheckButton.Border1  				"Border.Dark" 		// the left checkbutton border
		CheckButton.Border2  				"Border.Bright"		// the right checkbutton border
		CheckButton.Check					"Highlight1"		// color of the check itself

		DragDrop.DragFrame				"255 255 255 192"
		DragDrop.DropFrame				"150 255 150 255"

		Frame.ClientInsetX					10
		Frame.ClientInsetY					35
		Frame.BgColor					"TestColor"
		Frame.OutOfFocusBgColor				"63 70 57 255"
		Frame.FocusTransitionEffectTime			"0"			// time it takes for a window to fade in/out on focus/out of focus
		Frame.TransitionEffectTime				"0"			// time it takes for a window to fade in/out on open/close
		Frame.AutoSnapRange				"6"
		Frame.UsesAlphaBlending				1
		FrameSystemButton.Icon				"skins/Flat_Sand/resource/icon_steam"
		FrameSystemButton.DisabledIcon			"skins/Flat_Sand/resource/icon_steam_disabled"

		ListPanel.TextColor					DarkGray
		ListPanel.BgColor					Black
		ListPanel.SelectedTextColor				DarkGray
		ListPanel.SelectedBgColor				Highlight1BG
		ListPanel.SelectedOutOfFocusBgColor			SecBG
		ListPanel.DisabledTextColor				LightGray
		ListPanel.DisabledSelectedTextColor			DarkGray
		ListPanel.EmptyListInfoTextColor			DarkGray
		ListPanel.RowHeight				20
		ListPanel.PerPixelScrolling				1

		Menu.TextInset					"6"
		
		Panel.FgColor					"BorderSelection"
		Panel.BgColor					"PriBG"

		PropertySheet.TransitionEffectTime			"0"			// time to change from one tab to another
		PropertySheet.TabGap				3

		RichText.TextColor					DarkGray
		RichText.BgColor					ListBG
		RichText.SelectedTextColor				Black
		RichText.SelectedBgColor				Highlight1BG

		ScrollBar.Wide					21
		
		SectionedListPanel.CollapserWidth			16
		
		TextEntry.CursorColor				"DarkGray"
		
		// steam-specific settings
		GamesList.InstalledAppColor				GLInstalled
		GamesList.NotInstalledAppColor			GLNotInstalled
		GamesList.ReadyStatusColor				GLInstalled
		GamesList.UpdatingStatusColor			GLUpdating
		GamesList.NotInstalledStatusColor			GLNotInstalled
	}
	
	//
	//////////////////// CONTROLS //////////////////////////////
	//
	// describes how controls are rendered
	
	Controls
	{
		// typical control states:	default  disabled
		// button control states:	keyfocus  mouseover  mousedown  keyfocus_mouseover  defaultbutton  defaultbutton_mouseover
		// radio/checkbox states:	selected  selected_disabled  selected_keyfocus  selected_mouseover  selected_mousedown  selected_keyfocus_mouseover
		
		// color types:				textcolor  shadowtextcolor  selectedtextcolor  selectedbgcolor
		
		BaseControls
		{
			Button
			{
				textcolor	DialogText1
				bgcolor		Blank
				border		ButtonBorder
				
				mousedown	
				{
					border ButtonDepressedBorder
					textcolor	Highlight2
				}
				
				keyfocus
				{ 
					border ButtonKeyFocusBorder
					textcolor Highlight2
				}
				mouseover	{ textcolor Highlight2 }

				disabled
				{
					border			ButtonBorderDisabled
					textcolor		PriFGDisabled
					shadowtextcolor		Blank
				}
				
				keyfocus_mouseover		
				{ 
					border ButtonKeyFocusBorder
					textcolor Highlight2
				}
				
				defaultbutton
				{ 
					border		ButtonBorderDefault
				}
				defaultbutton_mouseover		
				{ 
					border		ButtonBorderDefault
					textcolor	Highlight2
				}
			}
			
			GripPanel
			{
				textcolor	TestColor
				bgcolor		TestColor
			}
			
			CheckButton
			{
				textcolor	DialogText1
				image		Graphics/chkUnselStd
				mouseover
				{
					textcolor Highlight3
					image	Graphics/chkUnselStd
				}
				mousedown	
				{
					textcolor Highlight3
					image Graphics/chkSelDown
				}
				selected	
				{
					image Graphics/chkSelStd
				}
				
				keyfocus
				{
					textcolor Highlight3 
					image	Graphics/chkUnselFocus
				}
				
				keyfocus_mouseover
				{
					textcolor Highlight3
					image	Graphics/chkUnselFocus
				}
				
				selected_mouseover	
				{ 
					textcolor Highlight3
					image	Graphics/chkSelStd
				}
				
				selected_mousedown
				{
					textcolor Highlight3
					image	Graphics/chkSelDown
				}
				
				selected_keyfocus
				{
					textcolor Highlight3
					image	Graphics/chkSelFocus
				}
				
				selected_keyfocus_mouseover
				{
					textcolor Highlight3 
					image	Graphics/chkSelFocus
				}
				
				disabled
				{
					textcolor		PriFGDisabled
					image Graphics/chkUnselDis
				}
				selected_disabled
				{
					textcolor		PriFGDisabled
					shadowtextcolor		Blank
					image	Graphics/chkSelDis
				}
			}
			
			CheckButtonList
			{
				border		InsetBorder
			}
			
			ComboBox
			{
				textcolor		DialogText1
				selectedtextcolor	DialogText1
				border			InputBorder
				mouseover		{ textcolor Highlight2 }
				mousedown		{ textcolor LightGray }
				keyfocus		{ textcolor Highlight2 }
				disabled		{ border InputBorderDisabled textcolor PriFGDisabled }
			}
			
			ComboBoxButton
			{
				textcolor	DialogText1
				bgcolor		Blank
				mouseover	{ textcolor Highlight2 }
				disabled	{ textcolor SecFGDisabled }
			}
			
			ContextLabel
			{
				textcolor	DialogText1
			}
			
			Divider
			{
				border		InsetBorder
			}			
			
			Frame
			{
				border		FrameBorder
				outoffocus	
				{
					border	FrameBorderDim
				}
			}
			
			FrameButton
			{
				border		NoBorder
				textcolor	TitleFG
				bgcolor		Blank
				mousedown	{ border InsetBorder }
				mouseover	{ textcolor Highlight1 }
				keyfocus	{ border ButtonKeyFocusBorder }
				outoffocus	
				{
					border NoBorder
					textColor TitleFGDim
				}
			}
		
			FrameSystemButton
			{
				border		NoBorder
				bgcolor		Blank
			}
			
			FrameTitle
			{
				textcolor	TitleFG
				bgcolor		Blank
				outoffocus	{ textcolor	TitleFGDim }
			}
			
			FrameBRGripPanel
			{
				textcolor		Blank
				shadowtextcolor		Blank
				border		ResizeBorder
				mouseover
				{
					border	ResizeMouseoverBorder
				}
				mousedown	
				{
					border ResizeMousedownBorder
				}
				disabled
				{
					border	ResizeBorder
				}
			}
			
			GraphPanel
			{
				textcolor	Highlight2
				bgcolor		MenuBG
				border		InsetBorder
			}

			HTML
			{
				bgcolor		Blank
				border		{}
			}
			
			HTMLInterior
			{
				bgcolor			Blank
				border			HTMLInteriorBorder
				scrollbar_visible	{ border HTMLInteriorBorderScrollbarVisible }
			}
//			
//			icon_button_news
//			{
//				textcolor		LightGray
//				bgcolor			ClayPriButtonBG
//				border			NewsBorder
//				mousedown		{ border NewsBorder_mousedown textcolor	Highlight1 }
//				keyfocus		{ border NewsBorder textcolor LightGray }
//				mouseover		{ border NewsBorder_mouseover textcolor Highlight1 }
//				disabled		{ border NewsBorder textcolor PriFGDisabled shadowtextcolor Blank }
//				keyfocus_mouseover	{ border NewsBorder_mouseover textcolor Highlight1 } 
//				defaultbutton		{ border NewsBorder textcolor LightGray }
//				defaultbutton_mouseover	{ border NewsBorder_mouseover textcolor Highlight1 }
//			}
//			
//			icon_button_friends
//			{
//				textcolor		LightGray
//				bgcolor			ClayPriButtonBG
//				border			FriendsBorder
//				mousedown		{ border FriendsBorder_mousedown textcolor	}
//				keyfocus		{ border FriendsBorder textcolor LightGray }
//				mouseover		{ border FriendsBorder_mouseover textcolor Highlight1 }
//				disabled		{ border FriendsBorder textcolor PriFGDisabled shadowtextcolor Blank }
//				keyfocus_mouseover	{ border FriendsBorder_mouseover textcolor Highlight1 } 
//				defaultbutton		{ border FriendsBorder textcolor LightGray }
//				defaultbutton_mouseover	{ border FriendsBorder_mouseover textcolor Highlight1 }
//			}
//
//			icon_button_servers
//			{
//				textcolor		LightGray
//				bgcolor			ClayPriButtonBG
//				border			ServersBorder
//				mousedown		{ border ServersBorder_mousedown textcolor	Highlight1 }
//				keyfocus		{ border ServersBorder textcolor LightGray }
//				mouseover		{ border ServersBorder_mouseover textcolor Highlight1 }
//				disabled		{ border ServersBorder textcolor PriFGDisabled shadowtextcolor Blank }
//				keyfocus_mouseover	{ border ServersBorder_mouseover textcolor Highlight1 } 
//				defaultbutton		{ border ServersBorder textcolor LightGray }
//				defaultbutton_mouseover	{ border ServersBorder_mouseover textcolor Highlight1 }
//			}
//			
//			icon_button_settings
//			{
//				textcolor		LightGray
//				bgcolor			ClayPriButtonBG
//				border			SettingsBorder
//				mousedown		{ border SettingsBorder_mousedown textcolor	Highlight1 }
//				keyfocus		{ border SettingsBorder textcolor LightGray }
//				mouseover		{ border SettingsBorder_mouseover textcolor Highlight1 }
//				disabled		{ border SettingsBorder textcolor PriFGDisabled shadowtextcolor Blank }
//				keyfocus_mouseover	{ border SettingsBorder_mouseover textcolor Highlight1 } 
//				defaultbutton		{ border SettingsBorder textcolor LightGray }
//				defaultbutton_mouseover	{ border SettingsBorder_mouseover textcolor Highlight1 }
//			}
//			
//			icon_button_support
//			{
//				textcolor		LightGray
//				bgcolor			ClayPriButtonBG
//				border			SupportBorder
//				mousedown		{ border SupportBorder_mousedown textcolor	Highlight1 }
//				keyfocus		{ border SupportBorder textcolor LightGray }
//				mouseover		{ border SupportBorder_mouseover textcolor Highlight1 }
//				disabled		{ border SupportBorder textcolor PriFGDisabled shadowtextcolor Blank }
//				keyfocus_mouseover	{ border SupportBorder_mouseover textcolor Highlight1 } 
//				defaultbutton		{ border SupportBorder textcolor LightGray }
//				defaultbutton_mouseover	{ border SupportBorder_mouseover textcolor Highlight1 }
//			}
//			
//			icon_button_MiniMeShrink
//			{
//				bgcolor			Blank
//				border			MiniMeShrinkBorder
//				mousedown		{ border MiniMeShrinkBorder textcolor	Blank }
//				keyfocus		{ border MiniMeShrinkBorder textcolor Blank }
//				mouseover		{ border MiniMeShrinkBorder_mouseover textcolor Blank }
//				disabled		{ border MiniMeShrinkBorder textcolor Blank shadowtextcolor Blank }
//				keyfocus_mouseover	{ border MiniMeShrinkBorder_mouseover textcolor Blank } 
//				defaultbutton		{ border MiniMeShrinkBorder textcolor Blank }
//				defaultbutton_mouseover	{ border MiniMeShrinkBorder_mouseover textcolor Blank }
//			}
//
//			icon_button_MiniMeExpand
//			{
//				bgcolor			Blank
//				border			MiniMeExpandBorder
//				mousedown		{ border MiniMeExpandBorder textcolor	Blank }
//				keyfocus		{ border MiniMeExpandBorder textcolor Blank }
//				mouseover		{ border MiniMeExpandBorder_mouseover textcolor Blank }
//				disabled		{ border MiniMeExpandBorder textcolor Blank shadowtextcolor Blank }
//				keyfocus_mouseover	{ border MiniMeExpandBorder_mouseover textcolor Blank } 
//				defaultbutton		{ border MiniMeExpandBorder textcolor Blank }
//				defaultbutton_mouseover	{ border MiniMeExpandBorder_mouseover textcolor Blank }
//			}

			Label
			{
				textcolor			DialogText1
				bgcolor				Blank
				selectedtextcolor	Highlight1				// used for when a label is associated with a control that has focus
			}
			
			LabelDull
			{
				textcolor			DialogText2
				bgcolor				Blank
				selectedtextcolor	Highlight1
			}

			LabelBright
			{
				textcolor			LightGray
				bgcolor				Blank
				selectedtextcolor	Highlight1
			}

			ListPanel
			{
				bgcolor		Blank
				border		ListPanelBorder
			}
			
			ListPanelInterior
			{
				bgcolor		ListBG
				border		ListPanelInteriorBorder
				scrollbar_visible
				{
					border	ListPanelScrollInteriorBorder
				}
			}
			
			ListPanelColumnHeader	
			{
				border		ListPanel.HeaderButtonBorder
				textcolor   DialogText1
				bgcolor		Blank
				mousedown
				{
					textcolor DialogText2
				}
				mouseover	{ textcolor Highlight1 }
			}
			
			ListPanelDragger
			{
				border		ListPanelDraggerBorder
			}

			ListViewPanel
			{
				border		InsetBorder
			}
			
			Menu
			{
				border		MenuBorder
				bgcolor		Blank
			}

			MenuBar		
			{
				bgcolor		Blank
			}
			
			MenuBarItem
			{
				textcolor	DialogText2
				bgcolor		Blank
				mouseover	{ textcolor Highlight1}
				mousedown	{ textcolor DialogText2 }
				selected	{ textcolor Highlight1 }
			}
			
			MenuItem
			{
				textcolor	MenuFG
				bgcolor		MenuBG
				mouseover	{ textcolor Highlight1FG bgcolor Highlight1BG }
				disabled
				{
					textcolor			MenuFGDisabled
//					shadowtextcolor			Blank
				}
			}
			
			MenuSeparator
			{
				textcolor	Blank
				bgcolor		Blank
				border		
				{ 
					render_bg 
					{ 
						"1"	"fill( x0, y0, x1, y1, MenuBG )" 
						"2"	"image( x0 + 2, y0 + 1, x0 + 12, y0 + 2, Graphics/mnuSepLeft)"
						"3"	"image( x0 + 12, y0 + 1, x1 - 12, y0 + 2, Graphics/mnuSepCenter)"
						"4"	"image( x1 - 12, y0 + 1, x1 - 2, y0 + 2, Graphics/mnuSepRight)"
					} 
				}
			}		
			
			PanelListPanel
			{
				border		InsetBorder
			}
			
			PanelHorizListPanel
			{
				border		InsetBorder
			}
			
			PageTab
			{
				
				textcolor	DialogText1
				bgcolor		ListBG
				border		TabBorder
				mouseover	{ textcolor Highlight1 }
				mousedown	{ textcolor DialogText2 }
				active	
				{ 
					border		TabActiveBorder 
					textcolor	Highlight1 
					bgcolor		Blank 
				}
				keyfocus		
				{
					border TabKeyfocusBorder
					textcolor Highlight1
				}
				keyfocus_mouseover
				{
					border TabKeyfocusBorder
					textcolor Highlight1
				}
			}
			
			PropertyPage
			{
				border		PropertyPageBorder
			}
			
			SteamGamesPage
			{
				bgcolor		TestColor
			}

				
			PropertySheet
			{
				bgcolor		Blank
				border		PropertySheetBorder
				bgcolor		Blank
				topleft		{ border PropertySheetBorderTopLeft }
				topright	{ border PropertySheetBorderTopRight }
			}
			
			ProgressBar
			{
				textcolor	DialogText1
				bgcolor		Blank
				border		InputBorder
			}
			
			RadioButton
			{
				
				textcolor	DialogText1
				image		Graphics/radUnselStd
				mouseover
				{
					textcolor Highlight2
					image	Graphics/radUnselStd
				}
				mousedown	
				{
					textcolor Highlight2
					image Graphics/radSelDown
				}
				selected	
				{
					image Graphics/radSelStd
				}
				
				keyfocus
				{
					textcolor Highlight2 
					image	Graphics/radUnselFocus
				}
				
				keyfocus_mouseover
				{
					textcolor Highlight2 
					image	Graphics/radUnselFocus
				}
				
				selected_mouseover	
				{ 
					textcolor Highlight2 
					image	Graphics/radSelStd
				}
				
				selected_mousedown
				{
					textcolor Highlight2
					image	Graphics/radSelDown
				}
				
				selected_keyfocus
				{
					textcolor Highlight2
					image	Graphics/radSelFocus
				}
				
				selected_keyfocus_mouseover
				{
					textcolor Highlight2  
					image	Graphics/radSelFocus
				}
				
				disabled
				{
					textcolor		PriFGDisabled
					image Graphics/radUnselDis
				}
				selected_disabled
				{
					textcolor		PriFGDisabled
					shadowtextcolor		Blank
					image	Graphics/radSelDis
				}
			}
			
			RichText
			{
				border		{}
			}
			
			RichTextInterior
			{
				border		ListPanelInteriorBorder
				scrollbar_visible
				{
					border	ListPanelScrollInteriorBorder
				}
			}
			
			ScrollBarSlider
			{
				//bgcolor TestColor
				mouseover	// doesn't work, wah
				{ 
				}
				mousedown	// doesn't work, wah
				{
				}
				slider		
				{
					border ScrollBarSliderBorder
					bgcolor Blank
				}
				slider_horiz
				{
					border Horiz_ScrollBarSliderBorder
					bgcolor Blank
				}
			}
			
			ScrollBarButton
			{
				border		ScrollBarButtonBorder
				textcolor	DialogText1
				mouseover	
				{
					textcolor Highlight1
				}
				mousedown	// doesn't work, wah
				{
				}
			}
			
			SectionedListPanel
			{
				bgcolor		Blank
				border		ListPanelBorder
			}

			SectionedListPanelInterior
			{
				bgcolor		ListBG
				border		ListPanelInteriorBorder
				scrollbar_visible
				{
					border	ListPanelScrollInteriorBorder
				}
			}
			
			SectionedListPanelItem
			{
				textcolor	DialogText1
				// set a border just to use the inset to adjust the text position
				border	{ inset "0 0 0 0" }
				
				selected
				{
					textcolor	Highlight1FG
					
					border
					{
						inset "0 0 0 0"
						render_bg
						{
							"0" "fill( x0 - 3, y0, x1, y1, Highlight1BG)" 
						}
					}
				}
			}
			
			SectionedListPanelHeader
			{
				textcolor	Highlight1
				
				border
				{
					render_bg
					{ 
						"2"	"image( x0 - 12, y1 - 2, x0, y1 - 1, Graphics/mnuSepLeft)"
						"3"	"image( x0, y1 - 2, x1 - 12, y1 - 1, Graphics/mnuSepCenter)"
						"4"	"image( x1 - 12, y1 - 2, x1 - 2, y1 - 1, Graphics/mnuSepRight)"
					} 
				}	
			}
			
			SectionedListPanelCollapser
			{
				textcolor	Highlight1
				bgcolor		Blank
				
				
			}
			
			Slider
			{
				textcolor		LightGray
				selectedtextcolor	MenuBG		// this is the color to draw the tracks
				
				disabled
				{
					textcolor		PriFGDisabled
					shadowtextcolor		Blank
				}
			}
			
			SplitterHandle
			{
				border		InsetBorder
			}
			
			TextEntry
			{
				border				InputBorder
				textcolor			DialogText1
				bgcolor				Blank
				selectedtextcolor		DialogText1	
				selectedbgcolor			Highlight1BG
				
				disabled
				{
					border			InputBorderDisabled
					textcolor		PriFGDisabled
					bgcolor			Blank
					selectedtextcolor	PriFGDisabled	
					selectedbgcolor		DialogText1
				}		
			}
			
			ToggleButton
			{
				textcolor	DialogText1
				bgcolor		Blank
				border		ButtonBorder
				
				mousedown		{ border ButtonDepressedBorder textcolor Highlight2 }
				mouseover		{ textcolor Highlight2 }
				keyfocus		{ textcolor DialogText1 }
				keyfocus_mouseover	{ textcolor Highlight2 }
				
				selected			{ border ButtonDepressedBorder textcolor Highlight2 }
				selected_mouseover		{ border ButtonDepressedBorder textcolor Highlight2 }
				selected_mousedown		{ border ButtonDepressedBorder textcolor Highlight2 }
				selected_keyfocus		{ border ButtonDepressedBorder textcolor Highlight2 }
				selected_keyfocus_mouseover	{ border ButtonDepressedBorder textcolor Highlight2 }

				disabled
				{
					border			ButtonBorderDisabled
					textcolor		PriFGDisabled
					shadowtextcolor		Blank
				}
			}
			
			TooltipWindow
			{
				textcolor	MenuFG
				border		ToolTipBorder
			}
			
			TreeView
			{
				textcolor	Blank
				bgcolor		SecBG
			}
			
			TreeNode
			{
				textcolor	DialogText1
				bgcolor		Blank
			}
			
			TreeViewSubPanel
			{
				bgcolor		Blank
			}
			
			TreeNodeText
			{
				textcolor	DialogText1
				bgcolor		Blank
				selectedtextcolor	Highlight1FG
				selectedbgcolor		Highlight1BG
			}
			
			URLLabel
			{
				textcolor			DialogText1
				bgcolor				Blank
			}

			WizardPanel
			{
				bgcolor		Blank
				border		FrameBorder
			}
			
			WizardSubPanel
			{ 
				border		WizardExperimentBorder
				bgcolor		Blank
			}
		}
		
		// specific overrides for controls living inside a page inside a wizard
		WizardSubPanelControls
		{
			Button
			{
				textcolor	LightGray
				bgcolor		Blank
				border		p_ButtonBorder
				
				mousedown
				{
					border p_ButtonDepressedBorder
					textcolor	Highlight2
				}

				keyfocus	
				{ 
					border p_ButtonKeyFocusBorder
					textcolor Highlight2
				}
				
				mouseover	
				{
					textcolor Highlight2
				}
				
				keyfocus_mouseover		
				{ 
					border p_ButtonKeyFocusBorder
					textcolor Highlight2
				}
				
				defaultbutton
				{ 
					textcolor LightGray
				}
				
				defaultbutton_mouseover		
				{ 
					textcolor Highlight2
				}

				disabled
				{
					border				p_ButtonBorderDisabled
					textcolor			SecFGDisabled
					shadowtextcolor		Blank
				}
			}

			ToggleButton
			{
				textcolor	DialogText1
				bgcolor		Blank
				border		p_ButtonBorder
				
				mousedown		{ border p_ButtonDepressedBorder textcolor Highlight2 }
				mouseover		{ textcolor Highlight2 }
				keyfocus		{ textcolor DialogText1 }
				keyfocus_mouseover	{ textcolor Highlight2 }
				
				selected			{ border p_ButtonDepressedBorder textcolor Highlight2 }
				selected_mouseover		{ border p_ButtonDepressedBorder textcolor Highlight2 }
				selected_mousedown		{ border p_ButtonDepressedBorder textcolor Highlight2 }
				selected_keyfocus		{ border p_ButtonDepressedBorder textcolor Highlight2 }
				selected_keyfocus_mouseover	{ border p_ButtonDepressedBorder textcolor Highlight2 }

				disabled
				{
					border			p_ButtonBorderDisabled
					textcolor		SecFGDisabled
					shadowtextcolor		Blank
				}
			}

			LabelDull
			{
				textcolor			DialogText2
				bgcolor				Blank
				selectedtextcolor	Highlight1
			}

			TextEntry
			{
				border				p_InputBorder
				textcolor			DialogText1
				bgcolor				Blank
				selectedtextcolor		DialogText1	
				selectedbgcolor			Highlight1BG
				
				disabled
				{
					border			p_InputBorderDisabled
					textcolor		SecFGDisabled
					bgcolor			Blank
					selectedtextcolor	LightGray	
					selectedbgcolor		DialogText1
				}		
			}
			
			ComboBox
			{
				textcolor		DialogText1
				selectedtextcolor	DialogText1
				border			p_InputBorder
				mouseover		{ textcolor White }
				mousedown		{ textcolor LightGray }
				keyfocus		{ textcolor Highlight2 }
				disabled
				{
					border			p_InputBorderDisabled
					textcolor		SecFGDisabled
					bgcolor			Blank
					selectedtextcolor	SecFGDisabled	
					selectedbgcolor		Blank
				}		
			}
			CheckButton
			{
				textcolor	DialogText1
				image		Graphics/chkUnselStd
				mouseover
				{
					textcolor Highlight3
					image	Graphics/chkUnselStd
				}
				mousedown	
				{
					textcolor Highlight3
					image Graphics/chkSelDown
				}
				selected	
				{
					image Graphics/chkSelStd
				}
				
				keyfocus
				{
					textcolor Highlight3
					image	Graphics/chkUnselFocus
				}
				
				keyfocus_mouseover
				{
					textcolor Highlight3
					image	Graphics/chkUnselFocus
				}
				
				selected_mouseover	
				{ 
					textcolor Highlight3
					image	Graphics/chkSelStd
				}
				
				selected_mousedown
				{
					textcolor Highlight3
					image	Graphics/chkSelDown
				}
				
				selected_keyfocus
				{
					textcolor Highlight3
					image	Graphics/chkSelFocus
				}
				
				selected_keyfocus_mouseover
				{
					textcolor Highlight3
					image	Graphics/chkSelFocus
				}
				
				disabled
				{
					textcolor		SecFGDisabled
					image Graphics/chkUnselDis
				}
				
				selected_disabled
				{
					textcolor		SecFGDisabled
					shadowtextcolor		Blank
					image	Graphics/chkSelDis
				}

			}
			ProgressBar
			{
				textcolor	LightGray
				bgcolor		Blank
				border		p_InputBorder
			}

			ListPanelInterior
			{
				bgcolor		ListBG
				border		p_ListPanelInteriorBorder
				scrollbar_visible
				{
					border	p_ListPanelScrollInteriorBorder
				}
			}

			RichTextInterior
			{
				border		p_ListPanelInteriorBorder
				scrollbar_visible
				{
					border	p_ListPanelScrollInteriorBorder
				}
			}

			SectionedListPanelInterior
			{
				bgcolor		ListBG
				border		p_ListPanelInteriorBorder
				scrollbar_visible
				{
					border	p_ListPanelScrollInteriorBorder
				}
			}

			HTMLInterior
			{
				bgcolor			Blank
				border			p_HTMLInteriorBorder
				scrollbar_visible	{ border p_HTMLInteriorBorderScrollbarVisible }
			}
		}

		// controls living in a property page		
		PropertyPageControls
		{
			Button
			{
				textcolor	LightGray
				bgcolor		Blank
				border		p_ButtonBorder
				
				mousedown
				{
					border p_ButtonDepressedBorder
					textcolor	Highlight2
				}

				keyfocus	
				{ 
					border p_ButtonKeyFocusBorder
					textcolor Highlight2
				}
				mouseover
				{
					textcolor Highlight2
				}
				
				keyfocus_mouseover		
				{ 
					border p_ButtonKeyFocusBorder
					textcolor Highlight2
				}
				
				defaultbutton
				{ 
					border p_ButtonBorderDefault
					textcolor LightGray
				}
				
				defaultbutton_mouseover		
				{ 
					border p_ButtonBorderDefault
					textcolor Highlight2
				}

				disabled
				{
					border				p_ButtonBorderDisabled
					textcolor			SecFGDisabled
					shadowtextcolor		Blank
				}
			}

			ToggleButton
			{
				textcolor	DialogText1
				bgcolor		Blank
				border		p_ButtonBorder
				
				mousedown		{ border p_ButtonDepressedBorder textcolor Highlight2 }
				mouseover		{ textcolor Highlight2 }
				keyfocus		{ textcolor DialogText1 }
				keyfocus_mouseover	{ textcolor Highlight2 }
				
				selected			{ border p_ButtonDepressedBorder textcolor Highlight2 }
				selected_mouseover		{ border p_ButtonDepressedBorder textcolor Highlight2 }
				selected_mousedown		{ border p_ButtonDepressedBorder textcolor Highlight2 }
				selected_keyfocus		{ border p_ButtonDepressedBorder textcolor Highlight2 }
				selected_keyfocus_mouseover	{ border p_ButtonDepressedBorder textcolor Highlight2 }

				disabled
				{
					border			p_ButtonBorderDisabled
					textcolor		SecFGDisabled
					shadowtextcolor		Blank
				}
			}

			LabelDull
			{
				textcolor			DialogText2
				bgcolor				Blank
				selectedtextcolor		Highlight1
			}

			TextEntry
			{
				border				p_InputBorder
				textcolor			DialogText1
				bgcolor				Blank
				selectedtextcolor		DialogText1	
				selectedbgcolor			Highlight1BG
				
				disabled
				{
					border			p_InputBorderDisabled
					textcolor		SecFGDisabled
					bgcolor			Blank
					selectedtextcolor	LightGray	
					selectedbgcolor		Blank
				}		
			}
			
			ComboBox
			{
				textcolor		DialogText1
				selectedtextcolor	DialogText1
				border			p_InputBorder
				mouseover		{ textcolor LightGray }
				mousedown		{ textcolor LightGray }
				keyfocus		{ textcolor Highlight2 }
				disabled
				{
					border			p_InputBorderDisabled
					textcolor		SecFGDisabled
					bgcolor			Blank
					selectedtextcolor	LightGray	
					selectedbgcolor		Blank
				}		
			}

			CheckButton
			{
				textcolor	DialogText1
				image		Graphics/chkUnselStd
				mouseover
				{
					textcolor Highlight3
					image	Graphics/chkUnselStd
				}
				mousedown	
				{
					textcolor Highlight3
					image Graphics/chkSelDown
				}
				selected	
				{
					image Graphics/chkSelStd
				}
				
				keyfocus
				{
					textcolor Highlight3
					image	Graphics/chkUnselFocus
				}
				
				keyfocus_mouseover
				{
					textcolor Highlight3
					image	Graphics/chkUnselFocus
				}
				
				selected_mouseover	
				{ 
					textcolor Highlight3
					image	Graphics/chkSelStd
				}
				
				selected_mousedown
				{
					textcolor Highlight3
					image	Graphics/chkSelDown
				}
				
				selected_keyfocus
				{
					textcolor Highlight3
					image	Graphics/chkSelFocus
				}
				
				selected_keyfocus_mouseover
				{
					textcolor Highlight3
					image	Graphics/chkSelFocus
				}
				
				disabled
				{
					textcolor		PriFGDisabled
					image Graphics/chkUnselDis
				}
				selected_disabled
				{
					textcolor		PriFGDisabled
					shadowtextcolor		Blank
					image	Graphics/chkSelDis
				}

			}

			ProgressBar
			{
				textcolor	LightGray
				bgcolor		Blank
				border		p_InputBorder
			}

			ListPanelInterior
			{
				bgcolor		ListBG
				border		p_ListPanelInteriorBorder
				scrollbar_visible
				{
					border	p_ListPanelScrollInteriorBorder
				}
			}

			RichTextInterior
			{
				border		p_ListPanelInteriorBorder
				scrollbar_visible
				{
					border	p_ListPanelScrollInteriorBorder
				}
			}

			SectionedListPanelInterior
			{
				bgcolor		ListBG
				border		p_ListPanelInteriorBorder
				scrollbar_visible
				{
					border	p_ListPanelScrollInteriorBorder
				}
			}

			HTMLInterior
			{
				bgcolor			Blank
				border			p_HTMLInteriorBorder
				scrollbar_visible	{ border p_HTMLInteriorBorderScrollbarVisible }
			}
		}
	}

	

	//
	//////////////////////// layout /////////////////////////////
	//
	// describes default layouts for controls that have and control their own children
	// works just like a normal settings .res file, except only positioning attributes are recognized
	LayoutTemplates
	{
		Frame
		{
			frame_menu
			{
				xpos	-16 // drawing offscreen. cajones.
				ypos	16
				wide	16
				tall	16
			}
			
			frame_title
			{
				xpos	6
				ypos	1
				wide	r35
				tall	20
				AutoResize	1
			}
			
			frame_captiongrip
			{
				xpos	4
				ypos	4
				wide	r20
				tall	20
				AutoResize	1
			}
			
			frame_minimize
			{
				xpos	r33
				ypos	3
				wide	16
				tall	16
				PinCorner	1
			}
			
			frame_close
			{
				xpos	r19
				ypos	3
				wide	16
				tall	16
				PinCorner	1
			}

			frame_brGrip
			{
				xpos	r10
				ypos	r10
				wide	10
				tall	10
				PinCorner	3
			}
		}
		
		PropertyDialog
		{
			sheet
			{
				xpos	8
				ypos	26
				wide	r8
				tall	r48
			}
			
			// these buttons are still a bit special - if some of them are hidden, they shuffle
			// across taking the place of other buttons to make sure there aren't gaps
			ApplyButton
			{
				xpos	r84
				ypos	r36
				wide	72
				tall	24
			}
			
			CancelButton
			{
				xpos	r164
				ypos	r36
				wide	72
				tall	24
			}
			
			OKButton
			{
				xpos	r244
				ypos	r36
				wide	72
				tall	24
			}
		}
		
		WizardPanel
		{
			subpanel
			{
				xpos	8
				ypos	28
				wide	r8
				tall	r48
				AutoResize	3
			}
		
			PrevButton
			{
				xpos	r280
				ypos	r36
				wide	84
				tall	24
				PinCorner	3
			}
			NextButton
			{
				xpos	r188
				ypos	r36
				wide	84
				tall	24
				PinCorner	3
			}
			CancelButton
			{
				xpos	r96
				ypos	r36
				wide	84
				tall	24
				PinCorner	3
			}
			FinishButton
			{
				xpos	r96
				ypos	r36
				wide	84
				tall	24
				PinCorner	3
			}
		}
	
	}

	//
	//////////////////////// FONTS /////////////////////////////
	//
	// describes all the fonts
	Fonts
	{
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		// fonts are used in order that they are listed
		"Default"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"13"
				"weight"	"0"
			}
		}
		"DefaultBold"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16"
				"weight"	"1000"
			}
		}
		"DefaultUnderline"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"13"
				"weight"	"800"
				"underline" "1"
			}
		}
		"DefaultSmall"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"11"
				"weight"	"800"
			}
		}
		ListSmall
		{
			1
			{
				name		Tahoma
				tall		12
				weight		0
			}
		}
		"DefaultVerySmall"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"0"
			}
		}

		"DefaultLarge"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"18"
				"weight"	"0"
			}
		}
		"UiBold"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12"
				"weight"	"1000"
			}
		}
		"MenuLarge"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"16"
				"weight"	"600"
				"antialias" "1"
			}
		}
		// this is the symbol font
		"Marlett"
		{
			"1"
			{
				"name"		"Marlett"
				"tall"		"14"
				"weight"	"0"
				"symbol"	"1"
			}
		}
		"DefaultFixed"
		{
			"1"
			{
				"name"		"Lucida Console"
				"tall"		"10"
				"weight"	"0"
			}
		}
	}
	

	//
	//////////////////// BORDERS //////////////////////////////
	//
	// describes all the border types
	Borders
	{
		// render render_bg
		// image fill gradient corner dashedrect
	
		BaseBorder	InsetBorder
		ComboBoxBorder	InsetBorder
		BrowserBorder	NoBorder
		CheckBorder	InsetBorder

		ListPanel.HeaderButtonBorder
		{
			"inset" "2 0 0 0"
		}
		
		PropertySheetBorder
		{
			render
			{
				//"1"		"image( x1, y0, x1 + 10, y0 + 10, Graphics/p_shadow_tr )"		// shadow top right
				//"2"		"image( x1, y0 + 10, x1 + 10, y1 - 3, Graphics/p_shadow_r )"		// shadow right
				//"3"		"image( x1 - 3, y1 - 3, x1 + 10, y1 + 10, Graphics/p_shadow_br )"	// shadow bottom right
				//"4"		"image( x0 + 10, y1, x1 - 3, y1 + 10, Graphics/p_shadow_b )"		// shadow bottom
				//"5"		"image( x0, y1, x0 + 10, y1 + 10, Graphics/p_shadow_bl )"		// shadow bottom left
				//"11"		"corner( x1 - 4, y0, x1, y0 + 4, DarkGreenBG )"		// topright
				//"13"		"corner( x1 - 3, y1 - 3, x1, y1, MenuBG )"		// bottomright
				//"14"		"corner( x0, y1 - 3, x0 + 3, y1, PriBG )"		// bottomleft
			}
		}

		PropertyPageBorder // border and background of an individual 'page' or tab
		{
			render_bg
			{
				"0"		"fill( x0, y0, x1, y1, SecBG )"
				//"1"		"gradient( x0, y1 - 40, x1, y1, SecBG, SecBGGradient)"
			}
		}
		
		WizardExperimentBorder
		{
			render_bg
			{
				"1"		"fill( x0, y0, x1, y1, SecBG )"
				//"2"		"gradient( x0, y1 - 40, x1, y1, SecBG, SecBGGradient)"
				//"3"		"image( x1, y0, x1 + 10, y0 + 10, Graphics/p_shadow_tr )"		// shadow top right
				//"4"		"image( x1, y0 + 10, x1 + 10, y1 - 3, Graphics/p_shadow_r )"	// shadow right
				//"5"		"image( x1 - 3, y1 - 3, x1 + 10, y1 + 10, Graphics/p_shadow_br )"	// shadow bottom right
				//"6"		"image( x0 + 10, y1, x1 - 3, y1 + 10, Graphics/p_shadow_b )"		// shadow bottom
				//"/7"		"image( x0, y1, x0 + 10, y1 + 10, Graphics/p_shadow_bl )"		// shadow bottom left
				//"8"		"corner( x1 - 4, y0, x1, y0 + 4, DarkGreenBG )"		// topright
				//"9"		"corner( x1 - 3, y1 - 3, x1, y1, MenuBG )"		// bottomright
				//"10"		"corner( x0, y1 - 3, x0 + 3, y1, PriBG )"		// bottomleft
			}
		}
		
		PropertySheetBorderTopLeft
		{
		}
		PropertySheetBorderTopRight
		{
		}
		
		ListPanel.HeaderButtonDepressedBorder	ListPanel.HeaderButtonBorder
		ListPanel.HeaderButtonKeyFocusBorder	ListPanel.HeaderButtonBorder
		
		ListPanelDraggerBorder
		{
			render_bg
			{
				//"0"		"fill( x0 + 4, y0, x0 + 5, y1, MenuBG )"
				//"1"		"fill( x0 + 5, y0, x0 + 6, y1, ClayDimLightGreen )"
			}
		}

		TitleButtonBorder	RaisedBorder
		TitleButtonDepressedBorder InsetBorder
		TitleButtonDisabledBorder
		{
			"backgroundtype" "0"
		}
		
		MenuBorder
		{
			"corner_rounding" "3"
			
			Right
			{
				"0"
				{
					"color" "SecBG"
					"offset" "0 0"
				}
			}

			Left
			{
				"0"
				{
					"color" "SecBG"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"0"
				{
					"color" "SecBG"
					"offset" "0 0"
				}
			}

			Top
			{
				"0"
				{
					"color" "SecBG"
					"offset" "0 0"
				}
			}
		}
		
		FrameBorder
		{
			"corner_rounding" "3"
			render_bg
			{
				"0"		"fill( x0, y0, x1, y1, PriBG )"
				"1"		"fill( x0, y0, x0+1, y1, SecBG )"
				"2"		"fill( x1-1, y0, x1, y1, SecBG )"
				"3"		"fill( x0, y1-1, x1, y1, SecBG )"
				//"1"		"gradient( x0, y0, x1, y0 + 200, DarkGreenBG, PriBG)"
				"4"		"fill( x0 + 0, y0 + 0, x1 - 0, y0 + 21, TitleBG )" //test
				//"2"		"image( x0 + 8, y0 + 8, x0 + 16, y0 + 16, Graphics/title_tl )"	// topleft
				//"3"		"image( x1 - 16, y0 + 8,  x1 -8, y0 + 16, Graphics/title_tr )"	// topright
			}
		}
		
		FrameBorderDim
		{
			"corner_rounding" "3"
			render_bg
			{
				"0"		"fill( x0, y0, x1, y1, PriBG )"
				"1"		"fill( x0, y0, x0+1, y1, TitleBGDim )"
				"2"		"fill( x1-1, y0, x1, y1, TitleBGDim )"
				"3"		"fill( x0, y1-1, x1, y1, TitleBGDim )"
				//"1"		"gradient( x0, y0, x1, y0 + 200, DarkGreenBG, PriBG)"
				"4"		"fill( x0 + 0, y0 + 0, x1 - 0, y0 + 21, TitleBGDim )" //test
				//"2"		"image( x0 + 8, y0 + 8, x0 + 16, y0 + 16, Graphics/title_tl )"	// topleft
				//"3"		"image( x1 - 16, y0 + 8,  x1 -8, y0 + 16, Graphics/title_tr )"	// topright
			}
		}

		InsetBorder
		{
			"inset" "0 0 1 1"
			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		DepressedBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		RaisedBorder
		{
			"inset" "0 0 1 1"
			
			render
			{
				"1"		"fill( x1, y0 + 1, x1 - 1, y1, Border.Dark )"		// right
				"2"		"fill( x0, y0, x0 + 1, y1 - 1, Border.Bright )"		// left
				"3"		"fill( x0, y0, x1, y0 + 1, Border.Bright )"			// top
				"4"		"fill( x0 + 1, y1 - 1, x1, y1, Border.Dark )"		// bottom
			}
		}
		
		RadioButtonKeyFocus		
		{
			"inset"	"0 0 0 0"
			render
			{
				"1"		"dashedrect( x0 + 1, y0 + 1, x1 - 1, y1 - 1, LightGray )"		
			}
		}
		
		ResizeBorder
		{
			render
			{
			//	"1"		"image( x0, y0, x1, y1, Graphics/resizer )"
			}
		}

		ResizeMouseoverBorder
		{
			render
			{
			//	"1"		"image( x0, y0, x1, y1, Graphics/resizer_mouseover )"
			}
		}
		
		ResizeMousedownBorder
		{
			render
			{
			//	"1"		"image( x0, y0, x1, y1, Graphics/resizer_mousedown )"
			}
		}

		ScrollBarButtonBorder
		{
			"inset" "2 0 0 0"
			render_bg
			{
				"1"		"fill( x0, y0, x1, y1, ScrollBG )"
				"2"		"fill( x0 + 4, y0 + 4, x0 + 17, y0 + 16, ScrollFG )"
				"3"		"image( x0 + 3, y0 + 3, x0 + 18, y0 + 17, Graphics/scrEnds )"
			}
		}
		
		ScrollBarButtonMousedownBorder // doesn't work, wah
		{
			"inset" "0 0 0 0"
			render_bg
			{
			//	"1"		"fill( x0, y0, x1, y1, PriBG )"
			//	"2"		"image( x0 + 4, y0 + 4, x0 + 20, y0 + 20, Graphics/ScrollButton_mousedown )"
			}
		}
		
		ScrollBarSliderBorder
		{
			render_bg
			{
				"1"		"fill( x0, y0 - 5000, x1, y1 + 5000, ScrollBG )"
				"2"		"fill( x0 + 4, y0 + 1, x0 + 17, y1 - 1, ScrollFG )"
				"3"		"image( x0 + 3, y0, x0 + 7, y0 + 4, Graphics/scrTopLeft )"
				"4"		"image( x0 + 14, y0, x0 + 18, y0 + 4, Graphics/scrTopRight )"
				"5"		"image( x0 + 3, y1 - 4, x0 + 7, y1, Graphics/scrBottomLeft )"
				"6"		"image( x0 + 14, y1 - 4, x0 + 18, y1, Graphics/scrBottomRight )"
				"7"		"image( x0 + 3, y0 + 4, x0 + 7, y1 - 4, Graphics/scrLeft )"
				"8"		"image( x0 + 14, y0 + 4, x0 + 18, y1 - 4, Graphics/scrRight )"
				"9"		"image( x0 + 7, y0, x0 + 14, y0 + 4, Graphics/scrTop )"
				"10"		"image( x0 + 7, y1 - 4, x0 + 14, y1, Graphics/scrBottom )"
			}
		}
		
		Horiz_ScrollBarSliderBorder
		{
			render_bg
			{
				"1"		"fill( x0 - 5000, y0, x1 + 5000, y1, ScrollBG )"
				"2"		"fill( x0 + 1, y0 + 4, x1 - 1, y0 + 16, SecBG )"
				"3"		"image( x0, y0 + 3, x0 + 4, y0 + 7, Graphics/scrTopLeft )"
				"4"		"image( x1 - 4, y0 + 3, x1, y0 + 7, Graphics/scrTopRight )"
				"5"		"image( x0, y0 + 13, x0 + 4, y0 + 17, Graphics/scrBottomLeft )"
				"6"		"image( x1 - 4, y + 13, x1, y0 + 17, Graphics/scrBottomRight )"
				"7"		"image( x0, y0 + 7, x0 + 4, y0 + 13, Graphics/scrLeft )"
				"8"		"image( x1 - 4, y0 + 7, x1, y0 + 13, Graphics/scrRight )"
				"9"		"image( x0 + 4, y0 + 3, x1 - 4, y0 + 7, Graphics/scrTop )"
				"10"		"image( x0 + 4, y0 + 13, x1 - 4, y0 + 17, Graphics/scrBottom )"
			}
		}

		ScrollBarSliderMousedownBorder // doesn't work, wah
		{
			render_bg
			{
				"1"		"fill( x0, y0, x1, y1, PriBG )"
				"2"		"image( x0 + 4, y0, x1 - 4, y0 + 4, Graphics/ScrollSlider_mousedown_t )"
				"3"		"fill( x0 + 4, y0 + 4, x1 - 4, y1 - 4, LightGray )"
				"4"		"image( x0 + 4, y1 - 4, x1 - 4, y1, Graphics/ScrollSlider_mousedown_b  )"
			}
		}

		ScrollBarSliderMouseoverBorder // doesn't work, wah
		{
			render_bg
			{
				"1"		"fill( x0, y0, x1, y1, PriBG )"
				"2"		"image( x0 + 4, y0, x1 - 4, y0 + 4, Graphics/ScrollSlider_mouseover_t )"
				"3"		"fill( x0 + 4, y0 + 4, x1 - 4, y1 - 4, LightGray )"
				"4"		"image( x0 + 4, y1 - 4, x1 - 4, y1, Graphics/ScrollSlider_mouseover_b  )"
			}
		}
		
		TabBorder
		{
			inset				"5 0 1 0"
			
			render_bg
			{
				"1"		"fill(  x0 + 3, y0 + 3, x1 + 3, y1 - 1, TabBGInactive )"		// body
				"2"		"image( x1 + 1, y0 + 2, x1 + 4, y0 + 5, Graphics/tabStdTopRight )"	// topright
				"3"		"image( x0 + 2, y0 + 2, x0 + 5, y0 + 5, Graphics/tabStdTopLeft )"	// topleft
				"4"		"image( x0 + 5, y0 + 2, x1 + 1, y0 + 3, Graphics/tabStdTop )"		// top
				"5"		"image( x0 + 2, y0 + 5, x0 + 3, y1 - 1, Graphics/tabStdLeft )"		// left
				"6"		"image( x1 + 3, y0 + 5, x1 + 4, y1 - 1, Graphics/tabStdRight )"		// right
			}
		}

		TabActiveBorder
		{
			inset				"5 0 1 -2"
			render_bg
			{
				"1"		"image( x1 + 1, y0 + 4, x1 + 4, y0 + 7, Graphics/tabStdTopRight )"	// topright
				"2"		"image( x0 + 2, y0 + 4, x0 + 5, y0 + 7, Graphics/tabStdTopLeft )"	// topleft
				"3"		"image( x0 + 5, y0 + 4, x1 + 1, y0 + 5, Graphics/tabStdTop )"		// top
				"4"		"image( x0 + 2, y0 + 7, x0 + 3, y1 - 1, Graphics/tabStdLeft )"		// left
				"5"		"image( x1 + 3, y0 + 7, x1 + 4, y1 - 1, Graphics/tabStdRight )"		// right
				"6"		"fill(  x0 + 3, y0 + 5, x1 + 3, y1 - 1, SecBG )"			// body
			}
		}

		TabKeyfocusBorder
		{
			inset				"5 0 1 -2"
			render_bg
			{
				"1"		"image( x1 + 1, y0 + 4, x1 + 4, y0 + 7, Graphics/tabStdTopRight )"	// topright
				"2"		"image( x0 + 2, y0 + 4, x0 + 5, y0 + 7, Graphics/tabStdTopLeft )"	// topleft
				"3"		"image( x0 + 5, y0 + 4, x1 + 1, y0 + 5, Graphics/tabStdTop )"		// top
				"4"		"image( x0 + 2, y0 + 7, x0 + 3, y1 - 1, Graphics/tabStdLeft )"		// left
				"5"		"image( x1 + 3, y0 + 7, x1 + 4, y1 - 1, Graphics/tabStdRight )"		// right
				"6"		"fill(  x0 + 3, y0 + 5, x1 + 3, y1 - 1, SecBG )"			// body
			}
		}

		ToolTipBorder
		{
			"corner_rounding" "2"
			render_bg
			{
				"1"		"fill( x0, y0, x1, y1, MenuBG )"
			}
			
			Right
			{
				"0"
				{
					"color" "SecBG"
					"offset" "0 0"
				}
			}

			Left
			{
				"0"
				{
					"color" "SecBG"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"0"
				{
					"color" "SecBG"
					"offset" "0 0"
				}
			}

			Top
			{
				"0"
				{
					"color" "SecBG"
					"offset" "0 0"
				}
			}
		}

		NewsBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_news )" }
		}
		NewsBorder_mouseover
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_news_mouseover )" }
		}
		NewsBorder_mousedown
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_news_mousedown )" }
		}
		FriendsBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_friends )" }
		}
		FriendsBorder_mouseover
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_friends_mouseover )" }
		}
		FriendsBorder_mousedown
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_friends_mousedown )" }
		}
		ServersBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_servers )" }
		}
		ServersBorder_mouseover
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_servers_mouseover )" }
		}
		ServersBorder_mousedown
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_servers_mousedown )" }
		}
		SettingsBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_settings )" }
		}
		SettingsBorder_mouseover
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_settings_mouseover )" }
		}
		SettingsBorder_mousedown
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_settings_mousedown )" }
		}
		SupportBorder
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_support )" }
		}
		SupportBorder_mouseover
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_support_mouseover )" }
		}
		SupportBorder_mousedown
		{
			inset				"0 0 8 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/icon_button_support_mousedown )" }
		}
		MiniMeShrinkBorder
		{
			inset				"0 0 0 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/mini_shrink )" }
		}
		MiniMeShrinkBorder_mouseover
		{
			inset				"0 0 0 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/mini_shrink_mouseover )" }
		}
		MiniMeExpandBorder
		{
			inset				"0 0 0 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/mini_expand )" }
		}
		MiniMeExpandBorder_mouseover
		{
			inset				"0 0 0 0"
			render_bg
			{ "1"		"image( x0, y0, x1, y1, Graphics/mini_expand_mouseover )" }
		}

		ButtonBorder
		{
			inset				"4 3 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, PriButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnStdRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnStdLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnStdTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnStdBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnStdTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnStdTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnStdBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnStdBottomLeft )"		// bottomleft
			}
		}

		ButtonKeyFocusBorder
		{
			inset				"4 4 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, PriButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnSelRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnSelLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnSelTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnSelBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnSelTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnSelTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnSelBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnSelBottomLeft )"		// bottomleft
			}
		}

		ButtonBorderDefault
		{
			inset				"4 4 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, PriButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnDefRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnDefLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnDefTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnDefBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnDefTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnDefTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnDefBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnDefBottomLeft )"		// bottomleft
			}
		}

		ButtonDepressedBorder
		{
			inset			"6 5 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, PriButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnSelRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnSelLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnSelTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnSelBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnSelTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnSelTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnSelBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnSelBottomLeft )"		// bottomleft
			}
		}

		ButtonBorderDisabled
		{
			inset				"4 4 4 4"
			render_bg
			{
				//"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, PriButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnDisRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnDisLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnDisTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnDisBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnDisTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnDisTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnDisBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnDisBottomLeft )"		// bottomleft
			}
		}
		
		p_ButtonBorder
		{
			inset				"4 4 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, SecButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnAltStdRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnAltStdLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnAltStdTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnAltStdBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnAltStdTopright )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnAltStdTopleft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnAltStdBottomright )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnAltStdBottomleft )"		// bottomleft
			}
		}

		p_ButtonKeyFocusBorder
		{
			inset				"4 4 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, SecButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnAltSelRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnAltSelLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnAltSelTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnAltSelBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnAltSelTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnAltSelTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnAltSelBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnAltSelBottomLeft )"		// bottomleft
			
				// focus edge
				//"13"		"dashedrect( x0 + 5, y0 + 5, x1 - 5, y1 - 5, LightGray )"		
			
			}
		}

		p_ButtonBorderDefault
		{
			inset				"4 4 4 4"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, SecButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnAltDefRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnAltDefLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnAltDefTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnAltDefBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnAltDefTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnAltDefTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnAltDefBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnAltDefBottomLeft )"		// bottomleft
			}
		}

		p_ButtonDepressedBorder
		{
			inset			"6 5 4 4"

			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, SecButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnAltSelRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnAltSelLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnAltSelTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnAltSelBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnAltSelTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnAltSelTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnAltSelBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnAltSelBottomLeft )"		// bottomleft
			}
		}

		p_ButtonBorderDisabled
		{
			inset				"4 4 4 4"
			render_bg
			{
				//"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, SecButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnAltDisRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnAltDisLeft )"		// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnAltDisTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnAltDisBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnAltDisTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnAltDisTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnAltDisBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnAltDisBottomLeft )"		// bottomleft
			}
		}
		
		ListPanelBorder 
		{
		}
		
		ListPanelInteriorBorder
		{
			inset				"0 0 0 0"
			render
			{
			//	"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/shadow_r )"		// right
			//	"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/shadow_l )"		// left
			//	"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/shadow_t )"		// top
			//	"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/shadow_b )"		// bottom
			//	"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/shadow_tr )"		// topright
			//	"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/shadow_tl )"		// topleft
			//	"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/shadow_br )"		// bottomright
			//	"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/shadow_bl )"		// bottomleft

			//	"9"		"corner( x1 - 3, y0, x1, y0 + 3, PriBG )"		// topright
			//	"10"		"corner( x0, y0, x0 + 3, y0 + 3, PriBG )"		// topleft
			//	"11"		"corner( x1 - 3, y1 - 3, x1, y1, PriBG )"		// bottomright
			//	"12"		"corner( x0, y1 - 3, x0 + 3, y1, PriBG )"		// bottomleft
			}
		}

		ListPanelScrollInteriorBorder
		{
			inset				"0 0 0 0"
			render
			{
			//	"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/shadow_r )"		// right
			//	"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/shadow_l )"		// left
			//	"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/shadow_t )"		// top
			//	"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/shadow_b )"		// bottom
			//	"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/shadow_tr )"		// topright
			//	"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/shadow_tl )"		// topleft
			//	"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/shadow_br )"		// bottomright
			//	"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/shadow_bl )"		// bottomleft

			//	"9"		"corner( x1 - 3, y0, x1, y0 + 3, PriBG )"		// topright
			//	"10"		"corner( x0, y0, x0 + 3, y0 + 3, PriBG )"		// topleft
			//	"11"		"corner( x1 - 3, y1 - 3, x1, y1, PriBG )"		// bottomright
			//	"12"		"corner( x0, y1 - 3, x0 + 3, y1, PriBG )"		// bottomleft
			}
		}

		p_ListPanelInteriorBorder
		{
			inset				"0 0 0 0"
			render
			{
			//	"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/shadow_r )"		// right
			//	"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/shadow_l )"		// left
			//	"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/shadow_t )"		// top
			//	"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/shadow_b )"		// bottom
			//	"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/shadow_tr )"		// topright
			//	"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/shadow_tl )"		// topleft
			//	"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/shadow_br )"		// bottomright
			//	"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/shadow_bl )"		// bottomleft
			//	
			//	"9"		"corner( x1 - 3, y0, x1, y0 + 3, SecBG )"		// topright
			//	"10"		"corner( x0, y0, x0 + 3, y0 + 3, SecBG )"		// topleft
			//	"11"		"corner( x1 - 3, y1 - 3, x1, y1, SecBG )"		// bottomright
			//	"12"		"corner( x0, y1 - 3, x0 + 3, y1, SecBG )"		// bottomleft
			}
		}

		p_ListPanelScrollInteriorBorder
		{
			inset				"0 0 0 0"
			render
			{
			//	"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/shadow_r )"		// right
			//	"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/shadow_l )"		// left
			//	"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/shadow_t )"		// top
			//	"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/shadow_b )"		// bottom
			//	"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/shadow_tr )"		// topright
			//	"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/shadow_tl )"		// topleft
			//	"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/shadow_br )"		// bottomright
			//	"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/shadow_bl )"		// bottomleft

			//	"9"		"corner( x1 - 3, y0, x1, y0 + 3, SecBG )"		// topright
			//	"10"		"corner( x0, y0, x0 + 3, y0 + 3, SecBG )"		// topleft
			//	"11"		"corner( x1 - 3, y1 - 3, x1, y1, SecBG )"		// bottomright
			//	"12"		"corner( x0, y1 - 3, x0 + 3, y1, SecBG )"		// bottomleft
			}
		}

		HTMLInteriorBorder
		{
			render_bg
			{
			//	"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/shadow_r )"		// right
			//	"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/shadow_l )"		// left
			//	"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/shadow_t )"		// top
			//	"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/shadow_b )"		// bottom
			//	"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/shadow_tr )"		// topright
			//	"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/shadow_tl )"		// topleft
			//	"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/shadow_br )"		// bottomright
			//	"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/shadow_bl )"		// bottomleft

			//	"9"		"corner( x1 - 4, y0, x1, y0 + 4, PriBG )"		// topright
			//	"10"		"corner( x0, y0, x0 + 4, y0 + 4, PriBG )"		// topleft
			//	"11"		"corner( x1 - 4, y1 - 4, x1, y1, PriBG )"		// bottomright
			//	"12"		"corner( x0, y1 - 4, x0 + 4, y1, PriBG )"		// bottomleft
			}
		}
		
		HTMLInteriorBorderScrollbarVisible
		{
			render_bg
			{
			//	"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/shadow_r )"		// right
			//	"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/shadow_l )"		// left
			//	"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/shadow_t )"		// top
			//	"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/shadow_b )"		// bottom
			//	"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/shadow_tr )"		// topright
			//	"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/shadow_tl )"		// topleft
			//	"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/shadow_br )"		// bottomright
			//	"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/shadow_bl )"		// bottomleft
			//
			//	"9"		"corner( x1 - 4, y0, x1, y0 + 4, PriBG )"		// topright
			//	"10"		"corner( x0, y0, x0 + 4, y0 + 4, PriBG )"		// topleft
			//	"11"		"corner( x1 - 4, y1 - 4, x1, y1, PriBG )"		// bottomright
			//	"12"		"corner( x0, y1 - 4, x0 + 4, y1, PriBG )"		// bottomleft
			}
		}
		
		p_HTMLInteriorBorder
		{
			render_bg
			{
			//	"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/shadow_r )"		// right
			//	"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/shadow_l )"		// left
			//	"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/shadow_t )"		// top
			//	"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/shadow_b )"		// bottom
			//	"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/shadow_tr )"		// topright
			//	"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/shadow_tl )"		// topleft
			//	"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/shadow_br )"		// bottomright
			//	"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/shadow_bl )"		// bottomleft
			
			//	"9"		"corner( x1 - 6, y0, x1, y0 + 6, SecBG )"		// topright
			//	"10"		"corner( x0, y0, x0 + 6, y0 + 6, SecBG )"		// topleft
			//	"11"		"corner( x1 - 6, y1 - 6, x1, y1, SecBG )"		// bottomright
			//	"12"		"corner( x0, y1 - 6, x0 + 6, y1, SecBG )"		// bottomleft
			}
		}
		
		p_HTMLInteriorBorderScrollbarVisible
		{
			render_bg
			{
			//	"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/shadow_r )"		// right
			//	"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/shadow_l )"		// left
			//	"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/shadow_t )"		// top
			//	"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/shadow_b )"		// bottom
			//	"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/shadow_tr )"		// topright
			//	"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/shadow_tl )"		// topleft
			//	"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/shadow_br )"		// bottomright
			//	"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/shadow_bl )"		// bottomleft

			//	"9"		"corner( x1 - 6, y0, x1, y0 + 6, SecBG )"		// topright
			//	"10"		"corner( x0, y0, x0 + 6, y0 + 6, SecBG )"		// topleft
			//	"11"		"corner( x1 - 6, y1 - 6, x1, y1, SecBG )"		// bottomright
			//	"12"		"corner( x0, y1 - 6, x0 + 6, y1, SecBG )"		// bottomleft
			}
		}

		MenuBarBorder
		{
		}
		
		MenuBarButtonBorder
		{
		}
		
		MenuBarButtonDepressedBorder
		{
		}
		
		InputBorder	// for text entry fields and drop-down controls and  boxes
		{
			inset				"4 0 4 0"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, PriButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnStdRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnStdLeft )"			// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnStdTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnStdBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnStdTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnStdTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnStdBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnStdBottomLeft )"		// bottomleft
			}		
		}

		p_InputBorder	// for text entry fields and drop-down controls and combo boxes INSIDE WIZARDS OR PROPERTY SHEETS
		{
			inset				"4 0 4 0"
			render_bg
			{
				"0"		"fill( x0 + 1, y0 + 1, x1 - 1, y1 - 1, SecButtonBG )"
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnAltStdRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnAltStdLeft )"			// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnAltStdTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnAltStdBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnAltStdTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnAltStdTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnAltStdBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnAltStdBottomLeft )"		// bottomleft
			}		
		}

		InputBorderDisabled
		{
			inset				"4 0 4 0"
			render_bg // current border is TEMP -- copied from disabled button
			{
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnDisRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnDisLeft )"			// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnDisTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnDisBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnDisTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnDisTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnDisBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnDisBottomLeft )"		// bottomleft
			}	
		}

		p_InputBorderDisabled
		{
			inset				"4 0 4 0"
			render_bg
			{
				"1"		"image( x1 - 10, y0 + 10, x1, y1 - 10, Graphics/btnAltDisRight )"		// right
				"2"		"image( x0, y0 + 10, x0 + 10, y1 - 10, Graphics/btnAltDisLeft )"			// left
				"3"		"image( x0 + 10, y0, x1 - 10, y0 + 10, Graphics/btnAltDisTop )"			// top
				"4"		"image( x0 + 10, y1 - 10, x1 - 10, y1, Graphics/btnAltDisBottom )"		// bottom
				"5"		"image( x1 - 10, y0, x1, y0 + 10, Graphics/btnAltDisTopRight )"			// topright
				"6"		"image( x0, y0, x0 + 10, y0 + 10, Graphics/btnAltDisTopLeft )"			// topleft
				"7"		"image( x1 - 10, y1 - 10, x1, y1, Graphics/btnAltDisBottomRight )"		// bottomright
				"8"		"image( x0, y1 - 10, x0 + 10, y1, Graphics/btnAltDisBottomLeft )"		// bottomleft
			}	
		}

		NoBorder
		{
			"inset" "0 0 0 0"
			render
			{
			}
		}
	}
}
